
import numpy as np
import math
import pylab as plt

from Dop_Python_Uti import Get_Dop_Profiles

path="d:/signal/dop5000/data_trav/"

#*************************************************************************
# Example 1
# ---------
# UDOP data file contains 1 graph of velocity profile from channel 1
# Extract all the profiles from the first block, compute the mean profile
# and plot the result.
#
Channel = 1
Block = 1
Graph = 1

#My_File = '1Graph_1Channel.bdd'
My_File = path + 'Dop_Data.bdd'
try:
  fid = open(My_File, 'rb');
except:
  print("The file", filename, " is not found")

# Read from file all the measured data of graph 1
#
[X, Y, Nb_Profiles, Channel_Parameters, TBP] = Get_Dop_Profiles(fid, Graph, Channel, Block)
#
# Check for some errors ....
if Nb_Profiles < 0 :
  if Nb_Profiles == -1:
    print('Not a comptabilble DOP data file')
  if Nb_Profiles == -2:
    print('Data file version not supported')
  if Nb_Profiles == -3:
    print('Unknown graph number')
  if Nb_Profiles == -4:
    print('Unknown channel')
  if Nb_Profiles == -5:
    print('Unknown block')
else:
  # Plot the mean profile
  # ---------------------
  Yp = np.mean(Y,axis=0)

  plt.figure()
  plt.plot(X, Yp)
  print('Number of profiles = ', Nb_Profiles)
  plt.show()

