
%**************************************************************************              
% Example 4
% ---------
% The UDOP file is a raw data file, containing IQ values
% The setting was acquisition of 200 gates for 10 emissions
%
% Extract the Q signal of emission number 6 and display it.
%
        
       Selected_Emission = 6
       Selected_Channel = 1
       Selected_Block = 1
       Selected_Curve = 1
       
       My_File = 'data_iq_exemple4.bdd';
       fid = fopen(My_File, 'r');
       if fid == -1
         error('The file name is unknown!');
       end
%
    
% Read the parameters table from the selected channel
% (Not usefull in this case....)
       [Para_Table, Error] = Get_Para_Table(fid, 1)
       
% Read from file all the measured data
%
       [X, Y, Info, Nb_Profiles, Nb_Gates] = Get_Dop_Profiles(fid, Selected_Curve, Selected_Channel, Selected_Block);       
%
        
% Extract the desired information
% The Y table contains a single line containing all the data in the format:
% I,Q couple from PRF_1....   then I,Q couple from PRF_2...., and so on

        j = 2*Nb_Gates*(Selected_Emission-1) + 2
        incr = 2
        for i=1:Nb_Gates
          X(i) = i;
          Q(i) = Y(j)
          j = j+incr
        end

% And plot the curve ...
        plot(X,Q);

        fclose(fid); 


       
         

       
       
       