       
%*************************************************************************       
% Example 2
% ---------
% UDOP data file contains 2 graph velocity profile and echo profile from
% channel 1. Display the 10th velocity and echo profile
%

       Selected_Channel = 1
       Selected_Block = 1
       Selected_Curve = 1
       
       My_File = 'Dop_data_profile_echo.bdd';
       fid = fopen(My_File, 'r');
       if fid == -1
         error('The file name is unknown!');
       end       
       [X, Y, Info, Nb_Profiles, Nb_Gates] = Get_Dop_Profiles(fid, Selected_Curve, Selected_Channel, Selected_Block);       
%
% Check for some errors ....
       switch Nb_Profiles
         case -1    
           error('Not a comptabilble DOP data file');
         case -2
            error('Data file version not supported');
         case -3
           error('Unknown graph number');
         case -4
           error('Unknown channel');              
       end
%       
       % Plot the velocity      
        subplot(2,1,1), plot(X, Y(10,:));

       % Plot the echo
       Selected_Curve = 2
       [X, Y, Info, Nb_Profiles, Nb_Gates] = Get_Dop_Profiles(fid, Selected_Curve, Selected_Channel, Selected_Block);
       subplot(2,1,2), plot(X, Y(10,:));

       fclose(fid);       
% 
       
       