        
%*************************************************************************         
% Example 1
% ---------
% UDOP data file contains 1 graph of velocity profile from channel 1
% Extract all the profiles from the first block, compute the mean profile
% and plot the result.
%
       Selected_Channel = 1
       Selected_Block = 1
       Selected_Curve = 1
       
       My_File = 'dop_data.bdd';              
       fid = fopen(My_File, 'r');
       if fid == -1
         error('The file name is unknown!');
       end
% Read from file all the measured data of graph 1
%
       [X, Y, Info, Nb_Profiles, Nb_Gates] = Get_Dop_Profiles(fid, Selected_Curve, Selected_Channel, Selected_Block);       
%
% Check for some errors ....
       switch Nb_Profiles
         case -1    
           error('Not a comptabilble DOP data file');
         case -2
            error('Data file version not supported');
         case -3
           error('Unknown graph number');
         case -4
           error('Unknown channel');      
         case -5
           error('Unknown block');            
       end
%
%
% Plot the 10th profile
% 
       plot(X, Y(1,:));    
       
       pause
       
% Compute the mean profile
       Ymean = mean(Y);
       plot(X, Ymean);

       fclose(fid);

       